#ifndef NDEBUG

#include "functor.h"
#include <new>
#include <cstdlib>
#include <set>

namespace lp {
	// Keep track of number of calls to functor new/delete
	// and pointers that have not been freed

	namespace {
		set<const Functor*> allocv;
		int newc = 0;
		int delc = 0;
		int del0 = 0;
	}


	void* Functor::operator new(size_t size)
	{
		++newc;
		Functor* ptr = static_cast<Functor*>(malloc(size));
		allocv.insert(ptr);
		return ptr;
	}

	void Functor::operator delete(void* ptr)
	{
		if (!ptr) {
			++del0;
			return; // ignore calls to nullptr
		}
		++delc;
		auto at = allocv.find(static_cast<Functor*>(ptr));
		if (at == allocv.end()) {
			cerr << "ERROR: allocv does not contain allocated functor: " << *((Functor*)ptr) << "\n";
			exit(1);
		}
		allocv.erase(at);
		free(ptr);
	}

	//============= Memory leak detection for proof_node =================//


	void print_memory_stat()
	{
		cerr << "------- Functor --------\n";
		cerr << "Number of calls to new:            " << newc << "\n";
		cerr << "Number of calls to delete object:  " << delc << "\n";
		cerr << "Number of calls to delete nullptr: " << del0 << "\n";
		if (!allocv.empty()) {
			cerr << "Error: some functors were not deallocated:\n";
			for_each(allocv.begin(),allocv.end(),[&](const Functor* p){
				cerr << "Not deallocated: " << *p << "\n"; 
			});
			assert(false);
		}

		cerr << "WARNING: compiled without debugging flag NDEBUG, heavy loss of performance\n";
	}

}

#endif



